<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTechvBDownloads_Api_vBDownloads_Import_Downloadsii extends DBTechvBDownloads_Api_vBDownloads_Import
{
	/**
	* A helper for the main class to determine if we have this mod.
	*
	* @protected	integer
	*/
	public $identifier = array(
		'mod' 		=> 'downloadsii',
		'table' 	=> 'dl2_files',
		'title' 	=> 'DownloadsII'
	);

	/**
	* Begins the import with categories
	*/
	public function step2()
	{
		global $vbphrase, $vbulletin;

		// Grab number of files
		$numFiles = VBDOWNLOADS::$db->fetchOne('SELECT COUNT(*) AS total FROM $' . $this->identifier['table']);

		if (!$numFiles)
		{
			// Error out
			throw new Exception($vbphrase['dbtech_downloads_no_files_to_import']);
		}

		foreach (array('dl2folderpath', 'dbtech_downloads_path_to_downloads') as $key)
		{
			if (substr($vbulletin->options[$key], 0, 2) == './')
			{
				$vbulletin->options[$key] = str_replace('./', DIR . '/', $vbulletin->options[$key]);
			}
		}

		if (!is_dir($vbulletin->options['dl2folderpath']) OR !is_readable($vbulletin->options['dl2folderpath']))
		{
			throw new Exception($vbphrase['dbtech_downloads_source_folder_not_dir_or_unreadable']);
		}

		if (!is_dir($vbulletin->options['dbtech_downloads_path_to_downloads']) OR !is_readable($vbulletin->options['dbtech_downloads_path_to_downloads']))
		{
			throw new Exception($vbphrase['dbtech_downloads_destination_folder_not_dir_or_unreadable']);
		}

		// Make ourselves a new temporary table
		VBDOWNLOADS::$db->query('
			CREATE TABLE IF NOT EXISTS $dbtech_downloads_import_category (
				oldcategoryid INT(10) UNSIGNED NOT NULL DEFAULT \'0\', 
				newcategoryid INT(10) UNSIGNED NOT NULL DEFAULT \'0\'
			)
		');
		VBDOWNLOADS::$db->query('TRUNCATE TABLE $dbtech_downloads_import_category');

		// Have local storage to save some queries
		$importCategories = array();

		// Grab all categories
		$categories = VBDOWNLOADS::$db->fetchAllKeyed('SELECT * FROM $dl2_categories', 'id');
		
		// By default only admins can access
		$permissions = array('view' => array(6 => 1), 'download' => array(6 => 1), 'upload' => array(6 => 1));

		// Add all the extensiongroups as default allowed
		$extensiongroups = array_keys(VBDOWNLOADS::$cache['extensiongroup']);

		foreach ($categories as $categoryid => $category)
		{
			if (!$categoryid)
			{
				// Skip this
				continue;
			}

			if ($existing = VBDOWNLOADS::$db->fetchRow('
				SELECT categoryid
				FROM $dbtech_downloads_category
				WHERE title = ?', array($category['name'])
			))
			{
				// We have an existing category
				VBDOWNLOADS::$db->insert('dbtech_downloads_import_category', array(
					'oldcategoryid' => $categoryid,
					'newcategoryid' => $existing['categoryid']
				));

				// Store locally too
				$importCategories[$categoryid] = $existing['categoryid'];

				print_description_row(construct_phrase($vbphrase['dbtech_downloads_imported_category_x'], $category['name']));

				// And we're done with this category
				continue;
			}

			// init data manager
			$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_CP);
			
			// category fields
			foreach (array(
				'title' => $category['name'],
				'description' => $category['description'],
				'permissions' => $permissions,
				'extensiongroups' => $extensiongroups,
				'displayorder' => $category['weight']
			) AS $key => $val)
			{
				// Set the values
				$dm->set($key, $val);
			}
			
			// Save! Hopefully.
			$newcategoryid = $dm->save();

			// Get rid of this
			unset($dm);

			// Insert the new categoryid
			VBDOWNLOADS::$db->insert('dbtech_downloads_import_category', array(
				'oldcategoryid' => $categoryid,
				'newcategoryid' => $newcategoryid
			));

			// Store locally too
			$importCategories[$categoryid] = $newcategoryid;

			print_description_row(construct_phrase($vbphrase['dbtech_downloads_imported_category_x'], $category['name']));
		}

		// Go through them again to update parent assignment
		foreach ($categories as $categoryid => $category)
		{
			if (!$categoryid)
			{
				// Skip this
				continue;
			}

			if (!$category['parent'])
			{
				// Skip this
				continue;
			}

			if (!$existing = VBDOWNLOADS::$db->fetchRow('
				SELECT *
				FROM $dbtech_downloads_category
				WHERE categoryid = ?', array($importCategories[$categoryid])
			))
			{
				// Skip this
				continue;
			}

			// init data manager
			$dm =& VBDOWNLOADS::initDataManager('Category', $vbulletin, ERRTYPE_CP);
				$dm->set_existing($existing);
				$dm->set('parentid', $importCategories[$category['parent']]);
			$dm->save();

			unset($dm);
		}
	}

	/**
	* Imports files
	*/
	public function step3()
	{
		global $vbphrase, $vbulletin;

		foreach (array('dl2folderpath', 'dbtech_downloads_path_to_downloads') as $key)
		{
			if (substr($vbulletin->options[$key], 0, 2) == './')
			{
				$vbulletin->options[$key] = str_replace('./', DIR . '/', $vbulletin->options[$key]);
			}
		}

		if (!is_dir($vbulletin->options['dl2folderpath']) OR !is_readable($vbulletin->options['dl2folderpath']))
		{
			throw new Exception($vbphrase['dbtech_downloads_source_folder_not_dir_or_unreadable']);
		}

		if (!is_dir($vbulletin->options['dbtech_downloads_path_to_downloads']) OR !is_readable($vbulletin->options['dbtech_downloads_path_to_downloads']))
		{
			throw new Exception($vbphrase['dbtech_downloads_destination_folder_not_dir_or_unreadable']);
		}

		// Grab all the category maps
		$importCategories = VBDOWNLOADS::$db->fetchAllSingleKeyed('SELECT * FROM $dbtech_downloads_import_category', 'oldcategoryid', 'newcategoryid');

		// Default perpage and current page num
		$perpage 	= 50;
		$page		= $vbulletin->input->clean_gpc('r', 'page', TYPE_UINT);

		// Limits for the SQL query
		$limitStart	= $perpage * $page;
		$limitEnd	= $page + $perpage;

		$files = VBDOWNLOADS::$db->fetchAll('
			SELECT 
				df.*, di.thumb
			FROM $dl2_files AS df 
			LEFT JOIN $dl2_images AS di ON(di.file = df.id)
			ORDER BY df.id ASC 
			LIMIT :limitStart, :limitEnd
		', array(
			':limitStart' 	=> $limitStart,
			':limitEnd' 	=> $limitEnd,
		));

		if (!count($files))
		{
			// And we're done
			VBDOWNLOADS::$db->query('DROP TABLE $dbtech_downloads_import_category');

			throw new Exception($vbphrase['dbtech_downloads_import_completed']);
		}

		foreach ($files as $file)
		{
			if (!$existing = VBDOWNLOADS::$db->fetchRow('
				SELECT downloadid
				FROM $dbtech_downloads_download
				WHERE userid = ?
					AND updated = ?
					AND title = ?
			', array(
				$file['uploaderid'],
				$file['lastedit'] ? $file['lastedit'] : $file['dateadded'],
				$file['title'],
			)))
			{
				$mirrors = array();
				if ($file['link'])
				{
					$mirrors[] = array(
						'link' => $file['url'], 
						'hits' => 0
					);
				}

				// init data manager
				$dm =& VBDOWNLOADS::initDataManager('Download', $vbulletin, ERRTYPE_CP);
					$dm->set_info('is_automated', true);
					
				// category fields
				foreach (array(
					'userid' 			=> $file['uploaderid'],
					'title' 			=> $file['title'],
					'description' 		=> $file['description'],
					'totaldownloads' 	=> $file['totaldownloads'],
					'numfiles' 			=> $file['link'] ? 0 : 1,
					'updated' 			=> $file['lastedit'] ? $file['lastedit'] : $file['dateadded'],
					'categoryid' 		=> $importCategories[$file['category']],
					'mirrors' 			=> $mirrors,
					'image' 			=> $file['thumb'],
					'moderation' 		=> $file['modqueue'],
				) AS $key => $val)
				{
					// Set the values
					$dm->set($key, $val);
				}
				
				// Save! Hopefully.
				$downloadid = $dm->save();

				unset($dm);

				print_description_row(construct_phrase($vbphrase['dbtech_downloads_imported_download_x'], $file['title']));
			}
			else
			{
				// Store this
				$downloadid = $existing['downloadid'];

				print_description_row(construct_phrase($vbphrase['dbtech_downloads_imported_download_x'], $file['title']));
			}

			if ($file['link'])
			{
				// This file was a link
				continue;
			}

			if ($file['thumb'] AND file_exists($vbulletin->options['dl2folderpath'] . '/' . $file['thumb']))
			{
				// Copy the thumbnail
				copy(
					$vbulletin->options['dl2folderpath'] . '/' . $file['thumb'], 
					$vbulletin->options['dbtech_downloads_path_to_downloads'] . '/' . $downloadid . '-' . $file['thumb']
				);
			}

			if (!$existing = VBDOWNLOADS::$db->fetchRow('
				SELECT fileid
				FROM $dbtech_downloads_file
				WHERE userid = ?
					AND dateline = ?
					AND downloadid = ?
			', array(
				$file['uploaderid'],
				$file['lastedit'] ? $file['lastedit'] : $file['dateadded'],
				$downloadid
			)))
			{
				// Determine and set file hash
				$filehash = file_exists($vbulletin->options['dl2folderpath'] . '/' . $file['url']) ? 
					md5_file($vbulletin->options['dl2folderpath'] . '/' . $file['url']) :
					md5($file['url'])
				;

				// init data manager
				$dm =& VBDOWNLOADS::initDataManager('File', $vbulletin, ERRTYPE_CP);
					$dm->set_info('is_automated', true);

				// category fields
				foreach (array(
					'userid' 		=> $file['uploaderid'],
					'filename' 		=> $file['url'],
					'dateline' 		=> $file['lastedit'] ? $file['lastedit'] : $file['dateadded'],
					'filesize' 		=> $file['size'],
					'downloads' 	=> $file['totaldownloads'],
					'downloadid' 	=> $downloadid,
					'hashkey' 		=> $filehash,
				) AS $key => $val)
				{
					// Set the values
					$dm->set($key, $val);
				}
				
				// Save! Hopefully.
				$fileid = $dm->save();

				unset($dm);

				print_description_row(construct_phrase($vbphrase['dbtech_downloads_imported_file_x'], $file['url']));
			}
			else
			{
				// Store this
				$fileid = $existing['fileid'];

				print_description_row(construct_phrase($vbphrase['dbtech_downloads_imported_file_x'], $file['url']));
			}

			if (
				file_exists($vbulletin->options['dl2folderpath'] . '/' . $file['url']) AND 
				!file_exists($vbulletin->options['dbtech_downloads_path_to_downloads'] . '/' . $fileid . '-' . $file['url'])
			)
			{
				// Copy the actual file
				copy(
					$vbulletin->options['dl2folderpath'] . '/' . $file['url'], 
					$vbulletin->options['dbtech_downloads_path_to_downloads'] . '/' . $fileid . '-' . $file['url']
				);
			}
		}

		// Update the counters
		VBDOWNLOADS::$db->query('
			UPDATE $dbtech_downloads_download AS download
			SET numfiles = (
				SELECT COUNT(*) FROM $dbtech_downloads_file AS file
				WHERE file.downloadid = download.downloadid
			)
		');		
		
		print_table_footer();

		// Move on to the next page
		$page++;

		print_cp_redirect("vbdownloads.php?" . $vbulletin->session->vars['sessionurl'] . "do=import&step=3&mod=" . $this->identifier['mod'] . "&page=$page");
		echo "<p><a href=\"vbdownloads.php?" . $vbulletin->session->vars['sessionurl'] . "do=import&amp;step=3&amp;mod=" . $this->identifier['mod'] . "&amp;page=$page\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";		
	}	
}

?>